// index.js

import {
    updateDocumentLanguage,
    updateElementLanguage,
    tr,
    setLanguage
} from "./i18n.js"
import {
    exposeToWindow,
    triggerEvent,
    delay,
    debounce
} from "./utils.js"

setLanguage("en");
updateDocumentLanguage();


function selectNicknameInput(id, container = document) {
    // return container.querySelector(.)
}

exposeToWindow({
    selectNicknameInput
});

async function handleNicknameInput(elem, e) {
    const delay = e.detail.delay || 500
    debounce(elem, () => {
        const id = elem.dataset.id;
        document.querySelector(`[class*="Voice_name"][data-id="${id}"]`).innerText = elem.value;
    }, delay);
}

function handleUseridInput(elem) {
    debounce(elem, () => {
        const id = elem.dataset.id;
        document.querySelector(`.voice_state[data-id="${id}"]`).dataset.userid = elem.value;
    });
}

function handleImgSourceInput(elem) {

}

function handleStateChange(elem) {

}

function copySettingUser(id, options = {}) {
    const template = document.getElementById('setting-template');
    const clone = template.content.cloneNode(true).firstElementChild;

    clone.querySelectorAll('[data-id]').forEach(el => {
        el.dataset.id = id;
    });

    for (const [key, value] of Object.entries(options)) {
        const elem = clone.querySelector(`[data-field="${key}"]`);
        if (elem) elem.value = value;
    }
    return clone;
}

function copyVoiceUser(id, options = {}) {
    const username = options.username ?? "";
    const userid = options.userid ?? "";
    const discordAvatarUrl = options.discordAvatarUrl ?? "./static/img/avatars/1.jpg";

    const template = document.getElementById('user-template');
    const clone = template.content.cloneNode(true);

    clone.querySelectorAll('[data-id]').forEach(el => {
        el.dataset.id = id;
    });

    return clone;
}

async function createUser(options = {}) {
    const username = options.username ?? "username";
    const userid = options.userid ?? "userid";
    const discordAvatarUrl = options.discordAvatarUrl ?? "./static/img/avatars/1.jpg";

    const id = getId();
    const dSettingUserList = document.getElementById("settingUserList");
    const dVoiceUserList = document.getElementById("voiceUserList");

    const settingUser = copySettingUser(id, {
        username,
        userid,
        discordAvatarUrl
    });
    const voiceUser = copyVoiceUser(id, {
        username,
        userid,
        discordAvatarUrl
    });

    const voiceNode = dVoiceUserList.appendChild(voiceUser);

    const settingNode = dSettingUserList.appendChild(settingUser);
    requestAnimationFrame(() => {
        triggerEvent(settingNode.querySelector('[data-field="username"]'), "input", {
            delay: 0
        });
        triggerEvent(settingNode.querySelector('[data-field="userid"]'), "input", {
            delay: 0
        });
    });

}


document.getElementById('add-user').addEventListener('click', createUser);

const getId = (function(start = 1) {
    let current = start;
    return function() {
        return current++;
    };
})();


const UserRoles = Object.freeze({
    IDLE: 'idle',
    TALKING: 'talking',
    MUTE: 'mute',
    DEAF: 'deaf',
});

(function() {
    const template = document.getElementById('setting-template');
    const select = template.content.querySelector(`[data-field="state"]`);
    Object.entries(UserRoles).forEach(([key, value]) => {
        const option = document.createElement('option');
        option.value = key;
        option.textContent = value;
        select.appendChild(option);
    });
})();

// Функция создания нового пользователя и конфигуратора
function createUser2() {
    const id = getId(); // уникальный id

    // Клонируем шаблон пользователя
    const userTemplate = document.getElementById('user-template');
    const userClone = userTemplate.content.cloneNode(true);
    const userElem = userClone.querySelector('.voice_state');
    const userAvatar = userClone.querySelector('.voice_avatar');
    const userName = userClone.querySelector('[class*="Voice_name"]');

    // Присваиваем data-id
    userElem.dataset.id = id;
    userAvatar.dataset.id = id;
    userName.dataset.id = id;

    // Добавляем в список пользователей
    document.getElementById('voiceUserList').appendChild(userClone);

    // Клонируем шаблон конфигуратора
    const configTemplate = document.getElementById('setting-template');
    const configClone = configTemplate.content.cloneNode(true);
    const configElem = configClone.querySelector('.user-data');

    // Присваиваем data-id
    configElem.dataset.id = id;
    configElem.querySelectorAll('[data-field]').forEach(input => {
        input.dataset.id = id;
    });

    // Добавляем select опции
    const select = configElem.querySelector('select');
    Object.entries(UserRoles).forEach(([key, value]) => {
        const option = document.createElement('option');
        option.value = key;
        option.textContent = value;
        select.appendChild(option);
    });

    // Событие изменения select
    select.addEventListener('change', () => {
        // Получаем текущий элемент пользователя
        const user = document.querySelector(`.voice_state[data-id="${id}"]`);
        if (!user) return;

        // Сбрасываем классы состояний
        user.classList.remove('wrapper_speaking', 'self_mute', 'self_deaf');

        // Присваиваем класс по выбранному состоянию
        switch (select.value) {
            case 'TALKING':
                user.classList.add('wrapper_speaking');
                break;
            case 'MUTE':
                user.classList.add('self_mute');
                break;
            case 'DEAF':
                user.classList.add('self_deaf');
                break;
            case 'IDLE':
            default:
                // ничего не добавляем
                break;
        }
    });

    // Вставляем конфигуратор в панель
    document.getElementById('side-panel').appendChild(configClone);
}


exposeToWindow({
    createUser,
    triggerEvent
});
exposeToWindow({
    handleNicknameInput,
    handleImgSourceInput,
    handleStateChange,
    handleUseridInput
});

createUser({
    username: "Игги",
    userid: "305000517535399936"
})
createUser({
    username: "Лансер",
    userid: "866418178895511562"
})
createUser({
    username: "Виртха",
    userid: "1318979158092546134"
})
createUser({
    username: "Джейд",
    userid: "694720007200047134"
})
createUser({
    username: "Лука",
    userid: "740871308673417286"
})
createUser({
    username: "ГМ",
    userid: "743236852458192919"
})

setInterval(() => {
    document.querySelectorAll(".voice_avatar").forEach(el => {
        el.classList.toggle("Voice_avatarSpeaking__hash");
    });
    document.querySelectorAll(".voice_state").forEach(el => {
        el.classList.toggle("wrapper_speaking");
    });
}, 2000);


const urlParams = new URLSearchParams(window.location.search);
if (urlParams.has('hidden')) {
    root.style.setProperty('--side-panel__width', 0, 'important');
    root.style.setProperty('--header__height', 0, 'important');
    root.style.setProperty('--footer__height', 0, 'important');
    document.getElementById('side-panel').style.transform = 'scale(0)';
    document.getElementById('header').style.transform = 'scaleY(0)';
    document.getElementById('footer').style.transform = 'scaleY(0)';

}